/*=============================================
EDITAR PERSONA
=============================================*/
$(".tablas").on("click", ".btnEditarServicio", function(){

	var idtipo_servicios = $(this).attr("idtipo_servicios");

	var datos = new FormData();
    datos.append("idtipo_servicios", idtipo_servicios);

    $.ajax({

      url:"ajax/servicios.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
      success:function(respuesta){

        //console.log(respuesta);
      
      	 $("#idtipo_servicios").val(respuesta["idtipo_servicios"]);	

	       $("#editarNombreServicio").val(respuesta["nombre"]);

         $("#editarTipoServicio").html(respuesta["descripcion"]);
         $("#editarTipoServicio").val(respuesta["descripcion"]);

	       $("#editarCatidadBolsas").val(respuesta["cantidad_bolsa"]);
	       $("#editarValorServicio").val(respuesta["valor_servicio"]);
                 
	  }

  	})

})




/*=============================================
ELIMINAR SERVIIO
=============================================*/
$(".tablas").on("click", ".btnEliminarServicio", function(){

	var idtipo_servicios = $(this).attr("idtipo_servicios");
	
	swal({
        title: '¿Está seguro de borrar el servicio?',
        text: "¡Si no lo está puede cancelar la acción!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, borrar servicio!'
      }).then(function(result){
        if (result.value) {
          
            window.location = "index.php?ruta=servicios&idtipo_servicios="+idtipo_servicios;
        }

  })

})




/*----------------------------------------
    Agregar servicios desde a ventana modal al Form
------------------------------------------*/

$("#servicio").click(function() {
  $("#modalAgregarServicio").modal("show");
  $("#modalAgregarServicio").attr('tipo', 'servicio');
});




$(".tablas").on('click', '.btnAgregarDatosS', function(event) {
  event.preventDefault();
  var idtipo_servicios = $(this).attr("idtipo_servicios");
  var tipo = $("#modalAgregarServicio").attr("tipo");

  let datos = new FormData();
    datos.append("idtipo_servicios", idtipo_servicios);

    $.ajax({

      url:"ajax/servicios.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
      success:function(respuesta){

        //console.log(respuesta);

        if(tipo === "servicio"){      
                      
            
            $("#nuevoTipoServicio").val(respuesta["nombre"]); 

            $("#modalAgregarServicio").modal('toggle');

            $("#nuevoDecripcionServ").val(respuesta["descripcion"]);
            $("#nuevoCantBolsa").val(respuesta["cantidad_bolsa"]);
            $("#nuevoValorServicio").val(`${respuesta["valor_servicio"]}.00`);
            $("#idtipo_servicios").val(respuesta["idtipo_servicios"]);
           
               
       }
    }

    })

});

$("#tipoServicio").on('change', function(event) {
  event.preventDefault();
 
  //$("#estadoServicio").prop('selectedIndex',0);
  //$("#zonaServicio").prop('selectedIndex',0);

  let perfil = $("#perfilSession").val();

  let tipoServicios = $("#tipoServicio").val();
  let estadoServicios = $("#estadoServicio").val();
  let zonaServicios = $("#zonaServicio").val();
  
  let datos = new FormData();
  datos.append("tipoServicios", tipoServicios);
  datos.append("estadosServicios",estadoServicios);
  datos.append("zonaServicios",zonaServicios);

    $.ajax({
      url:"ajax/servicios.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
    })
    .done(function(response) {
      console.log(response);
      let filas = "";

      $.each(response, function(index, val) {
        
        let nombre = val["nombres"];
        let servicio = "";
        let estado = "";
        let controles = "";
        let idservicio = val["idservicios"];
        if (val["idtipo_servicios"] == 1) {
          servicio = "Domiciliar";
        }else{
          servicio = "Comercio";
        }

        if(val["estado"] == 0){
          estado = `<span class="badge bg-green">Activo</span>`;
        }else if(val["estado"] == 1){
          estado = `<span class="badge bg-yellow">Suspendido</span>`;
        }else if(val["estado"] == 2){
          estado = `<span class="badge bg-black">Finalizado</span>`;          
        }

        controles = `<div> 
                      <button class="btn btn-info btnImprimirEstado" idservicios=${idservicio}>
                        <i class="fa fa-print"></i></button> 
                        <button class="btn btn-warning btnDetalleContrato" idservicios=${idservicio}><i class="fa fa-eye"></i></button>
                    `;

        if(perfil == "Administrador"){
          controles += ` <button class="btn btn-danger btnEliminarContrato" idservicios=${idservicio}><i class="fa fa-trash"></i></button>`;
        }     

        controles += `</div>`;       
    
        filas += `<tr id="fila">
          <td class="text-center">${index+1}</td>
          <td class="text-center">${val["codigo"]}</td>
          <td class="text-center">${nombre}</td>
          <td class="text-center">${val["documento"]}</td>
          <td class="text-center">${val["zona"]}</td>
          <td class="text-center">${val["numromeses"]}</td>
          <td class="text-center">${servicio}</td>
          <td class="text-center">${val["fecha"]}</td>
          <td class="text-center">${estado}</td>
          <td class="text-center">${controles}</td>
        </tr>`;
      });
     
      $("#serviCont").empty();
      $(".serviConti").append(filas);


    })
    .fail(function() {
      console.log("error");
    })
    .always(function() {
      console.log("complete");
    });
    

  

});

$("#estadoServicio").on('change', function(event) {
  event.preventDefault();

  //$("#zonaServicio").prop('selectedIndex',0);
  let perfil = $("#perfilSession").val();

  let tipoServicios = $("#tipoServicio").val();
  let estadoServicios = $("#estadoServicio").val();
  let zonaServicios = $("#zonaServicio").val();



  let datos = new FormData();
  datos.append("tipoServicios", tipoServicios);
  datos.append("estadosServicios",estadoServicios);
  datos.append("zonaServicios",zonaServicios);


    $.ajax({
      url:"ajax/servicios.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
    })
    .done(function(response) {
      console.log(response);
      let filas = "";

      $.each(response, function(index, val) {
        
        let nombre = val["nombres"];
        let servicio = "";
        let estado = "";
        let controles = "";
        let idservicio = val["idservicios"];
        if (val["idtipo_servicios"] == 1) {
          servicio = "Domiciliar";
        }else{
          servicio = "Comercio";
        }

        if(val["estado"] == 0){
          estado = `<span class="badge bg-green">Activo</span>`;
        }else if(val["estado"] == 1){
          estado = `<span class="badge bg-yellow">Suspendido</span>`;
        }else if(val["estado"] == 2){
          estado = `<span class="badge bg-black">Finalizado</span>`;          
        }

        controles = `<div> 
                      <button class="btn btn-info btnImprimirEstado" idservicios=${idservicio}>
                        <i class="fa fa-print"></i></button> 
                        <button class="btn btn-warning btnDetalleContrato" idservicios=${idservicio}><i class="fa fa-eye"></i></button>
                    `;

        if(perfil == "Administrador"){
          controles += ` <button class="btn btn-danger btnEliminarContrato" idservicios=${idservicio}><i class="fa fa-trash"></i></button>`;
        }     

        controles += `</div>`;   

        filas += `<tr id="fila">
          <td class="text-center">${index+1}</td>
          <td class="text-center">${val["codigo"]}</td>
          <td class="text-center">${nombre}</td>
          <td class="text-center">${val["documento"]}</td>
          <td class="text-center">${val["zona"]}</td>
          <td class="text-center">${val["numromeses"]}</td>
          <td class="text-center">${servicio}</td>
          <td class="text-center">${val["fecha"]}</td>
          <td class="text-center">${estado}</td>
          <td class="text-center">${controles}</td>
        </tr>`;
      });

      $("#serviCont").empty();
      $(".serviConti").append(filas);


    })
    .fail(function() {
      console.log("error");
    })
    .always(function() {
      console.log("complete");
    });
  

});


$("#zonaServicio").on('change', function(event) {
  event.preventDefault();
  
  let perfil = $("#perfilSession").val();

  let tipoServicios = $("#tipoServicio").val();
  let estadoServicios = $("#estadoServicio").val();
  let zonaServicios = $("#zonaServicio").val();
  //alert("buscando zona "+tipoServicios+ " "+estadoServicios+" "+zonaServicios);

  let datos = new FormData();
  datos.append("tipoServicios", tipoServicios);
  datos.append("estadosServicios",estadoServicios);
  datos.append("zonaServicios",zonaServicios);

    $.ajax({
      url:"ajax/servicios.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
    })
    .done(function(response) {
      console.log(response);
      let filas = "";

      $.each(response, function(index, val) {
  filas += `<tr id="fila">
    <td class="text-center">${index+1}</td>
    <td class="text-center">${val["BLOQUE"]}</td>
    <td class="text-center">${val["DIPLOMADO"]}</td>
    <td class="text-center">${val["TOTAL_INSCRITOS"]}</td>
  </tr>`;
      });

      $("#serviCont").empty();
      $(".serviConti").append(filas);


    })
    .fail(function() {
      console.log("error");
    })
    .always(function() {
      console.log("complete");
    });
  

});

// REPORTE DE COBRANZA GENERAL
$("#zonaReport").on('change', function(event) {
  event.preventDefault();
  
  let perfil = $("#perfilSession").val();

  let tipoServicios = $("#tipoServicio").val();
  let estadoServicios = $("#estadoServicio").val();
  let zonaBloques = $("#zonaReport").val();
  //alert("buscando zona "+tipoServicios+ " "+estadoServicios+" "+zonaServicios);

  let datos = new FormData();
  datos.append("tipoServicios", tipoServicios);
  datos.append("estadosServicios",estadoServicios);
  datos.append("zonaBloques",zonaBloques);

    $.ajax({
      url:"ajax/reportes.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
    })
    .done(function(response) {
      console.log(response);
      let filas = "";

      $.each(response, function(index, val) {
        
        let BLOQUE = val["BLOQUE"];
        let DIPLOMADO = val["DIPLOMADO"];


  

        filas += `<tr id="fila">
          <td class="text-center">${index+1}</td>
          <td class="text-center">${val["BLOQUE"]}</td>
          <td class="text-center">${val["DIPLOMADO"]}</td>
          <td class="text-center">${val["TOTAL_INSCRITOS"]}</td>
          <td class="text-center">${val["ALUMNOS ACTIVOS"]}</td>
          <td class="text-center">${val["MONTO TOTAL"]}</td>
          <td class="text-center">${val["MONTO_COBRADO"]}</td>
          <td class="text-center">${val["MONTO_POR_RECUPERAR"]}</td>
          <td class="text-center">${val["MONTO_ATRASADO"]}</td>
          <td class="text-center">${val["PERDIDO_POR_BAJAS"]}</td>
          <td class="text-center">${val["COMPLETADO"]}</td>
          <td class="text-center">${val["ACTIVO"]}</td>
          <td class="text-center">${val["ATRASADO"]}</td>
          <td class="text-center">${val["BAJAS"]}</td>

          
          
        </tr>`;
      });

      $("#serviCont").empty();
      $(".serviConti").append(filas);


    })
    .fail(function() {
      console.log("error");
    })
    .always(function() {
      console.log("complete");
    });
  

});

// REPORTE DE DETALLADO
$("#zonaDetallado").on('change', function(event) {
  event.preventDefault();
  
  let perfil = $("#perfilSession").val();

  let tipoServicioSs = $("#tipoServicio").val();
  let estadoServiciosS = $("#estadoServicio").val();
  let zonaDetallado = $("#zonaDetallado").val();
  //alert("buscando zona "+tipoServicios+ " "+estadoServicios+" "+zonaServicios);

  let datos = new FormData();
  datos.append("tipoServicioSs", tipoServicioSs);
  datos.append("estadosServiciosS",estadoServiciosS);
  datos.append("zonaDetallado",zonaDetallado);

    $.ajax({
      url:"ajax/reportes.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
    })
    .done(function(response) {
      console.log(response);
      let filas = "";

      $.each(response, function(index, val) {
        
        let BLOQUE = val["BLOQUE"];
        let DIPLOMADO = val["DIPLOMADO"];


  

        filas += `<tr id="fila">
          <td class="text-center">${index+1}</td>
          <td class="text-center">${val["BLOQUE"]}</td>
          <td class="text-center">${val["NOMBRE DE ALUMNO"]}</td>
          <td class="text-center">${val["DIPLOMADO"]}</td>
          <td class="text-center">${val["Inscripcion"]}</td>
          <td class="text-center">${val["Pago 1"]}</td>
          <td class="text-center">${val["Pago 2"]}</td>
          <td class="text-center">${val["Pago 3"]}</td>
          <td class="text-center">${val["Pago 4"]}</td>
          <td class="text-center">${val["Pago 5"]}</td>
          <td class="text-center">${val["Pago 6"]}</td>
          <td class="text-center">${val["Pago 7"]}</td>
          <td class="text-center">${val["Pago 8"]}</td>
          <td class="text-center">${val["Pago 9"]}</td>
          <td class="text-center">${val["Pago 10"]}</td>
          <td class="text-center">${val["Pago 11"]}</td>
          <td class="text-center">${val["Pago 12"]}</td>
          <td class="text-center">${val["Pago 13"]}</td>
          <td class="text-center">${val["Pago 14"]}</td>

          
          
        </tr>`;
      });

      $("#serviCont").empty();
      $(".serviConti").append(filas);


    })
    .fail(function() {
      console.log("error");
    })
    .always(function() {
      console.log("complete");
    });
  

});

// REPORTE DE COBRANZA GENERAL
$("#zonaDetallados").on('change', function(event) {
  event.preventDefault();
  
  let perfil = $("#perfilSession").val();

  let tipoServiciosD = $("#tipoServicio").val();
  let estadoServiciosD = $("#estadoServicio").val();
  let zonaBloquesD = $("#zonaDetallados").val();
  //alert("buscando zona "+tipoServicios+ " "+estadoServicios+" "+zonaServicios);

  let datos = new FormData();
  datos.append("tipoServiciosD", tipoServiciosD);
  datos.append("estadosServiciosD",estadoServiciosD);
  datos.append("zonaBloquesD",zonaBloquesD);

    $.ajax({
      url:"ajax/reportes.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
    })
    .done(function(response) {
      console.log(response);
      let filas = "";

      $.each(response, function(index, val) {
        
        let BLOQUE = val["BLOQUE"];
        let DIPLOMADO = val["DIPLOMADO"];


  

        filas += `<tr id="fila">
          <td class="text-center">${index+1}</td>
          <td class="text-center">${val["BLOQUE"]}</td>
          <td class="text-center">${val["DIPLOMADO"]}</td>
          <td class="text-center">${val["ESTADO_DEL_PAGO"]}</td>
          <td class="text-center">${val["PARTICIPANTE"]}</td>
          <td class="text-center">${val["FOLIO"]}</td>
          <td class="text-center">${val["METODO_DE_PAGO"]}</td>
          <td class="text-center">${val["BANCO"]}</td>
          <td class="text-center">${val["REFERENCIA"]}</td>
          <td class="text-center">${val["COMPROMETIDO"]}</td>
          <td class="text-center">${val["COBRADO"]}</td>
          <td class="text-center">${val["NOTAS DEL COBRADOR"]}</td>
          <td class="text-center">${val["FECHA_ACORDADA"]}</td>
          <td class="text-center">${val["FECHA_DE_PAGO"]}</td>
          <td class="text-center">${val["COBRADOR"]}</td>

          
          
        </tr>`;
      });

      $("#serviCont").empty();
      $(".serviConti").append(filas);


    })
    .fail(function() {
      console.log("error");
    })
    .always(function() {
      console.log("complete");
    });
  

});

// aqui termina el filtrado de contabilidad

// descarga de excel GENERAL PRIMERO
$(document).on('click', '#btnExportarExcel', function(event) {
  event.preventDefault();

  // Obtenemos los valores de los filtros
  let tipoServicios = $("#tipoServicio").val();
  let estadoServicios = $("#estadoServicio").val();
  let zonaBloques = $("#zonaReport").val();

  // Aquí haces una llamada AJAX para obtener los datos filtrados
  let datos = new FormData();
  datos.append("tipoServicios", tipoServicios);
  datos.append("estadosServicios", estadoServicios);
  datos.append("zonaBloques", zonaBloques);

  $.ajax({
    url: "ajax/reportes.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(response) {
      // Validar que la respuesta sea un array
      if (!Array.isArray(response)) {
        console.error("La respuesta no es un array:", response);
        alert("Error: Los datos recibidos no son válidos.");
        return;
      }

      // Validar que haya datos
      if (response.length === 0) {
        alert("No hay datos para exportar.");
        return;
      }

      // Prepara los datos para el Excel
      let wb = XLSX.utils.book_new(); // Crea un nuevo libro de trabajo
      let ws_data = [
        ['#', 'BLOQUE', 'DIPLOMADO', 'TOTAL DE INSCRITOS', 'ALUMNOS EN LISTA', 'MONTO TOTAL', 'MONTO COBRADO', 'MONTO POR RECUPERAR', 'MONTO ATRASADO', 'PERDIDO POR BAJAS', 'COMPLETADO', 'ACTIVO', 'ATRASADO', 'BAJAS']
      ];

      // Añade cada fila de datos al arreglo ws_data
      response.forEach((val, index) => {
        ws_data.push([
          index + 1,
          val["BLOQUE"],
          val["DIPLOMADO"],
          val["TOTAL_INSCRITOS"],
          val["ALUMNOS ACTIVOS"],
          parseFloat(val["MONTO TOTAL"]).toFixed(2),
          parseFloat(val["MONTO_COBRADO"]).toFixed(2),
          parseFloat(val["MONTO_POR_RECUPERAR"]).toFixed(2),
          parseFloat(val["MONTO_ATRASADO"]).toFixed(2),
          parseFloat(val["PERDIDO_POR_BAJAS"]).toFixed(2),
          val["COMPLETADO"],
          val["ACTIVO"],
          val["ATRASADO"],
          val["BAJAS"]
        ]);
      });

      let ws = XLSX.utils.aoa_to_sheet(ws_data); // Convierte el arreglo a una hoja
      XLSX.utils.book_append_sheet(wb, ws, "Reporte"); // Añade la hoja al libro

      // Genera el archivo Excel y lo descarga
      XLSX.writeFile(wb, 'reporte_recuperacion.xlsx');
    },
    error: function(xhr, status, error) {
      console.error("Error al obtener los datos:", error);
      console.error("Status:", status);
      console.error("Response:", xhr.responseText);
      alert("Error al obtener los datos para exportar. Por favor, verifica la consola para más detalles.");
    }
  });
});

// descarga de excel GENERAL PARA CONTABILIDAD
// Verificar que XLSX esté disponible cuando se carga el script
$(document).ready(function() {
  console.log("servicios.js cargado");
  console.log("XLSX disponible:", typeof XLSX !== 'undefined');
  
  // Verificar que el botón exista
  setTimeout(function() {
    var btn = document.getElementById('btnExportarExcelito');
    console.log("Botón btnExportarExcelito encontrado:", btn !== null);
    if (btn) {
      console.log("Botón existe en el DOM");
    } else {
      console.warn("Botón btnExportarExcelito NO encontrado en el DOM");
    }
  }, 1000);
});

// Usar delegación de eventos para asegurar que funcione incluso si el botón se carga dinámicamente
$(document).on('click', '#btnExportarExcelito', function(event) {
  event.preventDefault();
  event.stopPropagation();
  
  console.log("=== Botón Exportar Excel clickeado ===");

  // Verificar que XLSX esté disponible
  if (typeof XLSX === 'undefined') {
    alert("Error: La librería XLSX no está cargada. Por favor, recarga la página.");
    console.error("XLSX no está disponible");
    return;
  }

  // Obtenemos los valores de los filtros
  let tipoServiciosD = $("#tipoServicio").val() || "";
  let estadoServiciosD = $("#estadoServicio").val() || "";
  let zonaBloquesD = $("#zonaDetallados").val() || "";

  console.log("Valores de filtros:", {
    tipoServiciosD: tipoServiciosD,
    estadoServiciosD: estadoServiciosD,
    zonaBloquesD: zonaBloquesD
  });

  // Mostrar un indicador de carga
  var $btn = $(this);
  var originalHtml = $btn.html();
  $btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Generando...');

  // Aquí haces una llamada AJAX para obtener los datos filtrados
  let datos = new FormData();
  datos.append("tipoServiciosD", tipoServiciosD);
  datos.append("estadosServiciosD", estadoServiciosD);
  datos.append("zonaBloquesD", zonaBloquesD);

  $.ajax({
    url: "ajax/reportes.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(response) {
      console.log("Respuesta recibida:", response);
      
      // Restaurar el botón
      $btn.prop('disabled', false).html(originalHtml);
      
      // Validar que la respuesta sea un array
      if (!Array.isArray(response)) {
        console.error("La respuesta no es un array:", response);
        console.error("Tipo de respuesta:", typeof response);
        
        // Intentar parsear si es string
        if (typeof response === 'string') {
          try {
            response = JSON.parse(response);
            console.log("Respuesta parseada:", response);
          } catch (e) {
            console.error("No se pudo parsear la respuesta:", e);
            alert("Error: Respuesta del servidor no válida. Ver consola para más detalles.");
            return;
          }
        } else {
          alert("Error: Los datos recibidos no son válidos. Ver consola para más detalles.");
          return;
        }
      }

      // Validar que haya datos
      if (response.length === 0) {
        alert("No hay datos para exportar con los filtros seleccionados.");
        return;
      }

      console.log("Procesando " + response.length + " registros para Excel");

      try {
        // Prepara los datos para el Excel
        let wb = XLSX.utils.book_new(); // Crea un nuevo libro de trabajo
        let ws_data = [ 
          ['#', 'BLOQUE', 'DIPLOMADO', 'ESTADO DEL PAGO', 'PARTICIPANTE', 'FOLIO', 'METODO DE PAGO', 'BANCO', 'REFERENCIA', 'COMPROMETIDO', 'COBRADO', 'NOTAS DEL COBRADOR', 'FECHA ACORDADA', 'FECHA DE PAGO', 'COBRADOR']
        ];

        // Añade cada fila de datos al arreglo ws_data
        response.forEach((val, index) => {
          ws_data.push([
            index + 1,
            val["BLOQUE"] || '',
            val["DIPLOMADO"] || '',
            val["ESTADO_DEL_PAGO"] || '',
            val["PARTICIPANTE"] || '',
            val["FOLIO"] || '',
            val["METODO_DE_PAGO"] || '',
            val["BANCO"] || '',
            val["REFERENCIA"] || '',
            val["COMPROMETIDO"] || '',
            val["COBRADO"] || '',
            val["NOTAS DEL COBRADOR"] || '',
            val["FECHA_ACORDADA"] || '',
            val["FECHA_DE_PAGO"] || '',
            val["COBRADOR"] || ''
          ]);
        });

        let ws = XLSX.utils.aoa_to_sheet(ws_data); // Convierte el arreglo a una hoja
        XLSX.utils.book_append_sheet(wb, ws, "Reporte"); // Añade la hoja al libro

        // Genera el archivo Excel y lo descarga
        XLSX.writeFile(wb, 'reporte_general_detallado.xlsx');
        console.log("Archivo Excel generado exitosamente");
      } catch (error) {
        console.error("Error al generar el archivo Excel:", error);
        console.error("Stack trace:", error.stack);
        alert("Error al generar el archivo Excel: " + error.message);
      }
    },
    error: function(xhr, status, error) {
      // Restaurar el botón
      $btn.prop('disabled', false).html(originalHtml);
      
      console.error("Error en la petición AJAX:");
      console.error("Error:", error);
      console.error("Status:", status);
      console.error("Status Code:", xhr.status);
      console.error("Response Text:", xhr.responseText);
      
      // Intentar parsear la respuesta si es JSON
      try {
        let errorResponse = JSON.parse(xhr.responseText);
        console.error("Error parseado:", errorResponse);
      } catch (e) {
        console.error("No se pudo parsear la respuesta como JSON");
      }
      
      alert("Error al obtener los datos para exportar.\n\nCódigo de error: " + xhr.status + "\nMensaje: " + error + "\n\nPor favor, verifica la consola del navegador (F12) para más detalles.");
    }
  });
});


// descarga de excel de general de pagos - ELIMINADO (duplicado, se usa el de abajo con estilos)

// ESTE ES EL ES PARA LOS FILTROS Y COLORES
$(document).on('click', '#btnExportarExcelGral', function(event) {
  event.preventDefault();

  let tipoServicioSs = $("#tipoServicio").val();
  let estadosServiciosS = $("#estadoServicio").val();
  let zonaDetallado = $("#zonaDetallado").val();

  let datos = new FormData();
  datos.append("tipoServicioSs", tipoServicioSs);
  datos.append("estadosServiciosS", estadosServiciosS);
  datos.append("zonaDetallado", zonaDetallado);

  $.ajax({
    url: "ajax/reportes.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(response) {
      // Validar que la respuesta sea un array
      if (!Array.isArray(response)) {
        console.error("La respuesta no es un array:", response);
        alert("Error: Los datos recibidos no son válidos.");
        return;
      }

      // Validar que haya datos
      if (response.length === 0) {
        alert("No hay datos para exportar.");
        return;
      }

      let wb = XLSX.utils.book_new();
      let ws_data = [
        ['#', 'BLOQUE', 'NOMBRE DE ALUMNO', 'DIPLOMADO', 'Inscripcion', 'Pago 1', 'Pago 2', 'Pago 3', 'Pago 4', 'Pago 5', 'Pago 6', 'Pago 7', 'Pago 8', 'Pago 9', 'Pago 10', 'Pago 11', 'Pago 12', 'Pago 13', 'Pago 14']
      ];

      response.forEach((val, index) => {
        let row = [
          index + 1,
          val["BLOQUE"] || '',
          val["NOMBRE DE ALUMNO"] || '',
          val["DIPLOMADO"] || ''
        ];

        const pagos = ["Inscripcion", "Pago 1", "Pago 2", "Pago 3", "Pago 4", "Pago 5", "Pago 6", "Pago 7", "Pago 8", "Pago 9", "Pago 10", "Pago 11", "Pago 12", "Pago 13", "Pago 14"];
        pagos.forEach(pago => {
          // Validar que el valor exista y sea string antes de procesar
          let valorPago = val[pago] || '';
          if (typeof valorPago === 'string' && valorPago.trim() !== '') {
            // Intentar extraer el estado si existe el formato "fecha monto - ESTADO"
            let partes = valorPago.split('-');
            if (partes.length > 1) {
              let estado = partes[partes.length - 1].trim();
              // Agregar el valor completo (fecha, monto y estado)
              row.push(valorPago);
            } else {
              row.push(valorPago);
            }
          } else {
            row.push('');
          }
        });

        ws_data.push(row);
      });

      // Crear la hoja de cálculo - versión simplificada compatible
      let ws = XLSX.utils.aoa_to_sheet(ws_data);
      XLSX.utils.book_append_sheet(wb, ws, "Reporte");
      
      // Generar y descargar el archivo Excel
      try {
        XLSX.writeFile(wb, 'reporte_general_de_estatus_cobros.xlsx');
      } catch (error) {
        console.error("Error al generar el archivo Excel:", error);
        alert("Error al generar el archivo Excel. Por favor, verifica la consola para más detalles.");
      }
    },
    error: function(xhr, status, error) {
      console.error("Error al obtener los datos:", error);
      console.error("Status:", status);
      console.error("Response:", xhr.responseText);
      alert("Error al obtener los datos para exportar. Por favor, verifica la consola para más detalles.");
    }
  });
});